# UI / UX

UI와 UX 는 서비스 개발에 있어 매우 중요하고 긴밀한 관계를 가지고 있으나 그 역할에는 차이가 있다.

## UI(User Interface)와 UI Design

**UI(User Interface)** 는 사용자 인터페이스로 사용자가 마주하는 디자인, 레이아웃 등을 아우르는 개념이다. 사용자가 클릭하는 버튼, 읽는 텍스트, 이미지, 슬라이더, 텍스트 입력창 등 사용자가 상호 작용하는 모든것을 의미한다.

**UI Design** 은 UI의 모양과 작동 방식을 디자인하는 프로세스이다. 색상 및 타이포그래피에서 버튼, 스크롤 기능, 애니메이션과 전환 등에 이르기까지 웹 사이트, 소프트웨어 및 앱의 모든 시각적 및 인터랙티브한 속성을 디자인한다.

따라서 **UI Designer** 는 아래와 같은 역할을 수행한다.  
**제품의 모양과 느낌** : 고객 분석, 디자인 연구, 브랜딩 및 그래픽 개발, 사용자 가이드 및 스토리라인  
**반응성 및 상호작용성** : UI 프로토타이핑, 상호 작용 및 애니메이션, 모든 장치 화면 크기에 맞게 조정, 개발자와 함께 구현  
~**실행 및 분석** : UI 디자이너와의 조율, 개발자와의 조정, 목표 추적 및 통합, UX 분석 및 테스트~

<br/>

## UX(User Experiecne)와 UX Design

UX(User experience)라는 단어는 사람과 컴퓨터의 상호작용에 관한 다양한 주제를 연구하는 학문인 HCI(Human computer interaction)에서 사용자 중심 디자인(User centered design)을 설명할 때 언급되었으며 < The Design of Everyday Things >을 기술한 인지심리학자 도널드 노먼(Donald Norman, 1935~ )이 1993년 애플 컴퓨터의 부사장 재직 당시 자신의 직함을 ‘User experience architect’로 사용함으로써 UX라는 단어가 알려지기 시작했다.

**UX(User Experiecne)** 즉, 사용자 경험은 사용자가 어떤 시스템, 서비스, 제품 등을 직, 간접적으로 이용하면서 느끼는 총체적 경험이다. 서비스의 UI가 직관적이고 명확한지, 절차가 복잡하지는 않은지와 같은 직접적인 경험은 물론 서비스에 대한 접근성이나 오류에 대한 사후처리 등 모든 경험을 포함한다.

**UX Design** 은 이러한 경험의 전반적인 느낌을 디자인 해야한다. 따라서 특정 문제를 해결하기 위해 사용자의 전체 여정을 고려해야한다. 다학제적인 성격을 가지고 있어 심리학, 인류학, 컴퓨터 공학, 마케팅, 그래픽 디자인 및 산업 디자인 분야와 깊은 관련을 맺고 있다.

**UX Designer** 의 주요 역할은 아래와 같다.  
**전략 및 콘텐츠** : 경쟁사 분석, 고객 분석 및 사용자 조사, 제품 구조 및 전략, 콘텐츠 개발  
**와이어프레임 및 프로토타이핑** : 와이어프레임, 프로토타이핑, 테스트 및 반복, 개발 계획  
**실행 및 분석** : UI 디자이너와의 조율, 개발자와의 조정, 목표 추적 및 통합, UX 분석 및 테스트

<br/>

## UI와 UX의 관계

UI와 UX는 긴밀하게 상호작용하는 관계이다. UX를 바탕으로 유저들의 니즈를 파악하여 UI를 개선할 수 있다. 개선된 UI는 UX 만족도를 높일 수 있다.

그러나 UI와 UX의 발전 방향성이 항상 일치하는 것은 아니다. 대표적인 예로 MAC OS는 사용자 인터페이스(UI) 관점에서 보편성이 떨어져 불편함을 초래할 수 있다. 하지만 이는 새롭고 편리한 사용자 경험(UX)을 만들어낸다.

<br/>

---

## Reference

📄 https://modulabs.co.kr/blog/uxui-design/  
📄 https://pipelinemaker.tistory.com/51
